/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.common.util.HscProviderSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMOMHandle;

public class HSCOpPanelParInfo {
    protected int mParId;
    protected CIMObjectPath mObjPath;
    protected int mMaxInterval;
    protected int mCurInterval;
    protected int mCounter;
    protected CIMOMHandle mCimomHandle;
    protected String mCurLed = "";
    public static final String LED_BLANK = " ";
    protected boolean mClosed = false;

    public HSCOpPanelParInfo(int n, CIMObjectPath cIMObjectPath, String string, int n2, CIMOMHandle cIMOMHandle) {
        this.mParId = n;
        this.mObjPath = this.getObjectPath(n, cIMObjectPath, string);
        this.mMaxInterval = n2;
        this.mCurInterval = 1;
        this.mCounter = 1;
        this.mCimomHandle = cIMOMHandle;
    }

    public void reset(boolean bl) {
        if (bl) {
            this.mCurInterval = 1;
        }
        this.mCounter = this.mCurInterval;
    }

    private CIMObjectPath getObjectPath(int n, CIMObjectPath cIMObjectPath, String string) {
        if (n == 0) {
            return cIMObjectPath;
        }
        CIMObjectPath cIMObjectPath2 = null;
        String string2 = String.valueOf(n);
        int n2 = string2.length();
        while (n2 < 3) {
            string2 = "0" + string2;
            ++n2;
        }
        string2 = string2 + "*" + string;
        cIMObjectPath2 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
        cIMObjectPath2.addKey("Name", new CIMValue((Object)string2));
        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
        return cIMObjectPath2;
    }

    public int needPoll(int n) {
        if (this.mClosed) {
            return this.mMaxInterval;
        }
        this.mCounter -= n;
        if (this.mCounter <= 0) {
            return 0;
        }
        return this.mCounter;
    }

    public int pollLed(HscProviderSocket hscProviderSocket, Vector vector) {
        Hashtable hashtable = null;
        String string = null;
        try {
            hashtable = this.mParId == 0 ? HscProviderUtils.doCSPCommand("GET_CEC_OP_PANEL_VALUE", null, hscProviderSocket) : HscProviderUtils.doCSPCommand("GET_LPAR_OP_PANEL_VALUE", new String[]{Integer.toHexString(this.mParId)}, hscProviderSocket);
            string = this.getLedFromResponse(hashtable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (string == null) {
            string = this.getEmptyLedStr();
        }
        return this.handleNewLedVal(string, false, vector);
    }

    private String getLedFromResponse(Hashtable hashtable) {
        String string = "";
        int n = (Integer)hashtable.get("OP_PANEL_NLINES");
        Vector vector = (Vector)hashtable.get("CEC_OP_PANEL_LINE");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ((String)enumeration.nextElement()).trim() + "   ";
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            string2 = LED_BLANK;
        }
        return string2;
    }

    protected synchronized int handleNewLedVal(String string, boolean bl, Vector vector) {
        if (bl) {
            this.mClosed = true;
        } else if (this.mClosed) {
            return this.mMaxInterval;
        }
        try {
            CIMInstance cIMInstance = CimomWrapper.getInstance(this.mCimomHandle, this.mObjPath, new CIMClass(this.mObjPath.getObjectName()), false);
            this.mCurLed = (String)CimomWrapper.getProperty(cIMInstance, "OpPanelValue");
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
        if (this.mCurLed != null && this.mCurLed.equals(string)) {
            this.mCurInterval *= 2;
            if (this.mCurInterval > this.mMaxInterval) {
                this.mCurInterval = this.mMaxInterval;
            }
            this.mCounter = this.mCurInterval;
        } else {
            System.out.println("OpPanelValue changed from: " + this.mCurLed + " to: " + string);
            this.mCurInterval = 1;
            this.mCounter = 1;
            this.mCurLed = string;
            vector.addElement(this);
        }
        return this.mCounter;
    }

    public void updateCIMData() throws Exception {
        CIMInstance cIMInstance = CimomWrapper.getInstance(this.mCimomHandle, this.mObjPath, new CIMClass(this.mObjPath.getObjectName()), false);
        cIMInstance.setProperty("OpPanelValue", new CIMValue((Object)this.mCurLed));
        CimomWrapper.setInstance(this.mCimomHandle, this.mObjPath, cIMInstance);
        System.out.println("save OpPanelValue: " + this.mCurLed);
        AsynchEventManager.sendIndication(8, cIMInstance, null);
    }

    protected String getEmptyLedStr() {
        if (this.mParId == 0) {
            return "CANNOT_GET_LED";
        }
        return LED_BLANK;
    }

    public void close() {
        this.mCurInterval = 1;
        this.mCounter = 1;
        this.mCurLed = this.getEmptyLedStr();
        try {
            this.updateCIMData();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.mClosed = true;
    }

    public void print() {
        System.out.println("HSCOpPanelParInfo----------------");
        System.out.println("mParId: " + this.mParId);
        System.out.println("mMaxInterval: " + this.mMaxInterval);
        System.out.println("mCurInterval: " + this.mCurInterval);
        System.out.println("mCounter: " + this.mCounter);
        System.out.println("mCurLed: " + this.mCurLed);
        System.out.println("---------------------------------");
    }
}

